/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-12
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONCOORDINATESITEM_H
#define STATIONCOORDINATESITEM_H

#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT StationCoordinatesItem : public QAbstractItemModel
{
public:
  StationCoordinatesItem(QObject * parent=nullptr);

  void setStations(QList<NamedPoint> * s);
  void setStations(StationList * s);

  virtual int rowCount(const QModelIndex &parent=QModelIndex()) const;
  virtual int columnCount(const QModelIndex &parent=QModelIndex()) const;
  virtual QVariant data(const QModelIndex &index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
  virtual QModelIndex parent (const QModelIndex & ) const {return QModelIndex();}
  virtual QModelIndex index (int, int column, const QModelIndex & parent=QModelIndex()) const;
  virtual bool setData (const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
  virtual Qt::ItemFlags flags (const QModelIndex & ) const {return Qt::ItemIsSelectable | Qt::ItemIsEditable | Qt::ItemIsEnabled;}

  void beginStationChange() {beginResetModel();}
  void endStationChange() {endResetModel();}
private:
  StationList * _stationSignalsList;
  QList<NamedPoint> * _stationList;
};

} // namespace GeopsyGui

#endif // STATIONCOORDINATESITEM_H
