/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-08-30
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SEISMICEVENTITEM_H
#define SEISMICEVENTITEM_H

#include <GeopsyCore.h>
#include <QtGui>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT SeismicEventItem : public QAbstractTableModel
  {
    Q_OBJECT
  public:
    SeismicEventItem(QObject * parent=nullptr);
    ~SeismicEventItem();

    void setDatabase(SignalDatabase * db);
    SignalDatabase * dataBase() const {return _db;}

    SeismicEvent * at(int index) const {return _list.at(index);}

    virtual int rowCount(const QModelIndex &) const;
    virtual int columnCount(const QModelIndex &) const;
    virtual QVariant data(const QModelIndex & index, int role=Qt::DisplayRole) const;
    virtual QVariant headerData(int section, Qt::Orientation orientation, int role=Qt::DisplayRole) const;
    virtual bool setData (const QModelIndex & index, const QVariant & value, int role=Qt::EditRole);
    virtual Qt::ItemFlags flags (const QModelIndex & index) const;
    virtual void sort(int column, Qt::SortOrder order=Qt::AscendingOrder);

  private slots:
    void databaseDestroyed();
    void add(SeismicEvent * e);
    void remove(SeismicEvent * e);
  signals:
    void eventsChanged();
  private:
    bool commitModification(SeismicEvent * originalEvent,
                            const SeismicEvent& newEvent);
    static bool sortLessThan(const SeismicEvent * e1, const SeismicEvent * e2);
    static int _sortColumn;
    static Qt::SortOrder _sortOrder;
    SignalDatabase * _db;
    QList<SeismicEvent *> _list;
  };

} // namespace GeopsyGui

#endif // SEISMICEVENTITEM_H

