/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-18
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PickParameterwidget.h"
#include "ui_PickParameterwidget.h"

namespace GeopsyGui {

  PickParameterWidget::PickParameterWidget(QWidget *parent) :
    QWidget(parent),
    _ui(new Ui::PickParameterWidget)
  {
    _ui->setupUi(this);

    _ui->amplitudeThreshold->setMaximum(std::numeric_limits<double>::infinity());
    _ui->holdOffDelay->setMaximum(std::numeric_limits<double>::infinity());
  }

  PickParameterWidget::~PickParameterWidget()
  {
    delete _ui;
  }

  void PickParameterWidget::updateAllFields()
  {
    TRACE;
     on_amplitudeRelative_currentIndexChanged(0);
  }

  void PickParameterWidget::on_amplitudeRelative_currentIndexChanged(int)
  {
    TRACE;
    if(_ui->amplitudeRelative->currentIndex()==0) {
      _ui->amplitudeThreshold->setSuffix(" %");
      _ui->amplitudeThreshold->setMaximum(100.0);
    } else {
      _ui->amplitudeThreshold->setSuffix(QString());
      _ui->amplitudeThreshold->setMaximum(std::numeric_limits<double>::infinity());
    }
    emit parametersChanged();
  }

  void PickParameterWidget::getParameters(PickParameters& param) const
  {
    TRACE;
    if(_ui->amplitudeThresholdGroup->isChecked()) {
      if(_ui->amplitudeRelative->currentIndex()==0) {
        param.setAmplitudeThresholdType(PickParameters::RelativeAmplitudeThreshold);
        param.setAmplitudeThreshold(_ui->amplitudeThreshold->value()*0.01);
      } else {
        param.setAmplitudeThresholdType(PickParameters::AbsoluteAmplitudeThreshold);
        param.setAmplitudeThreshold(_ui->amplitudeThreshold->value());
      }
    } else {
      param.setAmplitudeThresholdType(PickParameters::NoAmplitudeThreshold);
    }
    param.setHoldOffDelay(_ui->holdOffDelay->value());
  }

  void PickParameterWidget::setParameters(const PickParameters& param)
  {
    TRACE;
    _ui->amplitudeThresholdGroup->setChecked(param.amplitudeThresholdType()!=PickParameters::NoAmplitudeThreshold);
    _ui->amplitudeRelative->setCurrentIndex(param.amplitudeThresholdType()==PickParameters::RelativeAmplitudeThreshold ? 0 : 1);
    switch(param.amplitudeThresholdType()) {
    case PickParameters::NoAmplitudeThreshold:
    case PickParameters::AbsoluteAmplitudeThreshold:
      _ui->amplitudeThreshold->setValue(param.amplitudeThreshold());
      break;
    case PickParameters::RelativeAmplitudeThreshold:
      _ui->amplitudeThreshold->setValue(param.amplitudeThreshold()*100.0);
      break;
    }
    _ui->holdOffDelay->setValue(param.holdOffDelay());
  }

} // namespace GeopsyGui
