/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-03-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include "PickItem.h"

namespace GeopsyGui {

/*!
  \class PickItem PickItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Initialize
*/
PickItem::PickItem(PicksProperties * picks)
  : QAbstractTableModel(picks)
{
  TRACE;
  _picks=picks;
}

int PickItem::rowCount(const QModelIndex &) const
{
  TRACE;
  // One more for Events pseudo time picks
  return TimePick::registeredNames().count()+1;
}

int PickItem::columnCount(const QModelIndex &) const
{
  TRACE;
  return PICKITEM_ATTRIBUTE_COUNT;
}

QVariant PickItem::data(const QModelIndex &index, int role) const
{
  TRACE;
  // Directly addresses properties...
  int pid=PICKITEM_ATTRIBUTE_COUNT*index.row()+index.column();
  switch (role) {
  case Qt::EditRole:
  case Qt::DisplayRole:
    if(index.column()==PICKITEM_ATTRIBUTE_NAME) return _picks->value(pid);
    break;
  case Qt::BackgroundRole:
    if(index.column()==PICKITEM_ATTRIBUTE_COLOR) return _picks->value(pid);
    break;
  case Qt::CheckStateRole:
    if(index.column()==PICKITEM_ATTRIBUTE_VISIBLE)
      return _picks->value(pid).toBool() ? Qt::Checked : Qt::Unchecked;
    break;
  default:
    break;
  }
  return QVariant();
}

QVariant PickItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  if(orientation==Qt::Horizontal) {
    switch(section) {
    case PICKITEM_ATTRIBUTE_NAME: return tr("Name");
    case PICKITEM_ATTRIBUTE_VISIBLE: return tr("Visible");
    case PICKITEM_ATTRIBUTE_COLOR: return tr("Color");
    default: return QVariant();
    }
  } else {
    return section+1;
  }
}

bool PickItem::setData(const QModelIndex & index, const QVariant & value, int role)
{
  TRACE;
  // Directly addresses properties...
  int pid=PICKITEM_ATTRIBUTE_COUNT*index.row()+index.column();
  switch (role) {
  case Qt::EditRole:
    if(index.column()==PICKITEM_ATTRIBUTE_NAME) {
      _picks->touched(_picks->propertyValue(pid), value);
      return true;
    }
    break;
  case Qt::BackgroundRole:
    if(index.column()==PICKITEM_ATTRIBUTE_COLOR) {
      _picks->touched(_picks->propertyValue(pid), value);
      return true;
    }
    break;
  case Qt::CheckStateRole:
    if(index.column()==PICKITEM_ATTRIBUTE_VISIBLE) {
      _picks->touched(_picks->propertyValue(pid), value==Qt::Checked);
      return true;
    }
  default:
    break;
  }
  return false;
}

Qt::ItemFlags PickItem::flags (const QModelIndex & index) const
{
  switch(index.column()) {
  case PICKITEM_ATTRIBUTE_NAME:
    return Qt::ItemIsEnabled | Qt::ItemIsEditable;
  case PICKITEM_ATTRIBUTE_VISIBLE:
    return Qt::ItemIsUserCheckable | Qt::ItemIsEnabled;
  default:
    return Qt::ItemIsEnabled;
  }
}

} // namespace GeopsyGui
