/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-07-09
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include "CitySignalItem.h"

namespace GeopsyGui {

#define CITY_SIGNAL_N_INFOS 12

/*!
  \class CitySignalItem CitySignalItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
CitySignalItem::CitySignalItem(CityScanner * scanner, QObject * parent)
    : QAbstractItemModel(parent)
{
  TRACE;
  _scanner=scanner;
}

/*!
  Description of destructor still missing
*/
CitySignalItem::~CitySignalItem()
{
  TRACE;
}

int CitySignalItem::rowCount(const QModelIndex &parent) const
{
  TRACE;
  if( !parent.isValid())
    return _scanner->count();
  return 0;
}

int CitySignalItem::columnCount(const QModelIndex & ) const
{
  TRACE;
  return CITY_SIGNAL_N_INFOS;
}

QVariant CitySignalItem::data(const QModelIndex &index, int role) const
{
  TRACE;
  if( !index.isValid() ||
       index.row() >= _scanner->count() ||
       index.column() >=CITY_SIGNAL_N_INFOS) return QVariant();
  const CitySignal * sig=_scanner->at(index.row());
  switch (role) {
  case Qt::DisplayRole:
    switch (index.column()) {
    case 0:
        return sig->erased() ? tr("Yes") : tr("No");
    case 1:
        return sig->startTime().toString("yyyy-MM-dd hh:mm:ss");
    case 2:
        return sig->endTime().toString("yyyy-MM-dd hh:mm:ss");
    case 3:
        return sig->fileIndex();
    case 4:
      return sig->channelNum();
    case 5:
      return sig->duration();
    case 6:
      return sig->gain();
    case 7:
      return sig->maxAllowedAmpl();
    case 8:
      return sig->maxReachedAmpl();
    case 9:
      return sig->frequency();
    case 10:
      return sig->nSamples();
    case 11:
      return sig->saturation();
    default:
        return QVariant();
    }
    return QVariant();
  case Qt::UserRole:
    return QByteArray(reinterpret_cast<const char *>(&sig), sizeof(CitySignal *));
  default:
    return QVariant();
  }
}

QVariant CitySignalItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  if(orientation==Qt::Horizontal) {
    switch (section) {
    case 0:
        return tr("Erased");
    case 1:
        return tr("Start time");
    case 2:
        return tr("End time");
    case 3:
        return tr("File index");
    case 4:
        return tr("Channel num");
    case 5:
        return tr("Duration");
    case 6:
        return tr("Gain");
    case 7:
        return tr("Max Allowed Ampl");
    case 8:
        return tr("Max Reached Ampl");
    case 9:
        return tr("Frequency");
    case 10:
        return tr("N Samples");
    case 11:
        return tr("Saturation");
    default:
        return QVariant();
    }
  } else {
    return section + 1;
  }
}

QModelIndex CitySignalItem::parent (const QModelIndex & ) const
{
  TRACE;
  return QModelIndex();
}

QModelIndex CitySignalItem::index (int row, int column, const QModelIndex & ) const
{
  TRACE;
  if(column < 0 || column >=CITY_SIGNAL_N_INFOS ||
       row < 0 || row >= _scanner->count()) return QModelIndex();
  return createIndex(row, column);
}


} // namespace GeopsyGui
