/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-28
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEWINDOW_H
#define TIMEWINDOW_H

#include <QGpCoreTools.h>

#include "TimeRange.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT TimeWindow : public TimeRange, public XMLClass
  {
  public:
    TimeWindow(const DateTime& start, const DateTime& end, const Color& c=Qt::black)
      : TimeRange(start, end), XMLClass() {_color=c;}
    TimeWindow(const DateTime& start, double length, const Color& c=Qt::black)
      : TimeRange(start, length), XMLClass() {_color=c;}
    TimeWindow(const TimeWindow& o)
      : TimeRange(o), XMLClass() {_color=o._color;}
    virtual ~TimeWindow() {}

    virtual const QString& xml_tagName() const {return xmlTimeWindowTag;}
    static const QString xmlTimeWindowTag;

    Color color() const {return _color;}
    void setColor(Color c) {_color=c;}

    virtual void xml_attributes(XML_ATTRIBUTES_ARGS) const;
    virtual bool xml_setAttributes(XML_SETATTRIBUTES_ARGS);
  private:
    Color _color;
  };

} // namespace GeopsyCore

#endif // TIMEWINDOW_H
