/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-23
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEPICK_H
#define TIMEPICK_H

#include "MetaData.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class TimePickSignal;

  class GEOPSYCORE_EXPORT TimePick : public MetaData
  {
    METADATA_CLASS(TimePick)
  public:
    TimePick() {}
    TimePick(const TimePick& o) : MetaData(), _values(o._values) {}

    virtual bool operator==(const MetaData& o) const;
    virtual void operator=(const MetaData& o);

    virtual QStringList subNames() const;
    virtual QStringList indexList(int) const {return registeredNames();}
    virtual QString name(int, const QString& index) const;
    virtual QString baseName(int) const;
    virtual QString title(int, const QString& index) const;

    virtual QString toString(const QString& index) const;
    virtual bool fromString(const QString& index, QString string);

    DateTime value(const QString& name) const;
    void removeValue(const QString& name);
    void setValue(const QString& name, DateTime t);
    QStringList names() const;

    virtual bool isArray(int) const {return true;}
    int count() const {return _names.count();}
    virtual int count(int) const {return _names.count();}
    virtual bool hasIndex(int) const {return true;}
    virtual bool hasIndex(int, const QString& index) const;
    virtual QVariant data(int, const QString& index) const;
    virtual bool setData(int, const QString& index, const QVariant& val);
    virtual int compare(int, const QString& index, const MetaData& o) const;

    static bool registered(const QString& name) {return _name2index.contains(name);}
    static QStringList registeredNames() {return _name2index.keys();}
    static QStringList unlockedNames();
    static void renamePick(const QString& oldName, const QString& newName);
    static bool pickLocked(const QString& name);
    static void setPickLocked(const QString& name, bool l);
    static QString nextUnlockedPick(const QString& name);
    static QString previousUnlockedPick(const QString& name);

    virtual void writeProperties(XMLStream& s, const XMLSaveAttributes& attributes) const;
  private:
    class Name
    {
    public:
      Name(const QString& n) : _value(n), _locked(false) {}

      const QString& value() const {return _value;}
      void setValue(const QString& v) {_value=v;}

      bool locked() const {return _locked;}
      void setLocked(bool l) {_locked=l;}
    private:
      QString _value;
      bool _locked;
    };

    static Name& pickName(int index);
    static int pickIndex(const QString& name);
    static bool pickLocked(int index);

    static QMap<QString, int> _name2index;
    static QList<Name> _names;

    QMap<int, DateTime> _values;
  };

} // namespace GeopsyCore

#endif // TIMEPICK_H
