/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-08-26
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SYSCOMHEADER_H
#define SYSCOMHEADER_H

#include "GeoSignal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     /* set alignment to 1 byte boundary */

class GEOPSYCORE_EXPORT SyscomHeader
{
public:
  static Signal::Components component(int channel);
protected:
  struct Time {
    uchar SECOND;
    uchar MINUTE;
    uchar HOUR;
    uchar DAY;
    uchar MONTH;
    uchar YEAR;
  };
  struct Lsb {
    qint16 MANTISSA;
    char EXPONENT;
  };
  static DateTime startTime(const Time& t);
  static int bcd2int(uchar bcd);
  static double countPerVolt(const Lsb& l);
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // SYSCOMHEADER_H
