/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-10
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONLIST_H
#define STATIONLIST_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "StationSignals.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT StationList : public QList<StationSignals *>
{
  TRANSLATIONS("StationList")
public:
  StationList();
  ~StationList();

  bool addSignal(Signal * sig);
  bool addSignals(SubSignalPool * subPool);

  void setComponents(StationSignals::Components c);
  bool hasAllComponents() const;

  StationSignals::Components components() const {return _components;}
  int nComponents() const {return StationSignals::nComponents(_components);}
  Signal::Components component(int index) const {return StationSignals::component(index, _components);}

  QList<NamedPoint> pointList() const;
private:
  StationSignals::Components _components;
};

} // namespace GeopsyCore

#endif // STATIONLIST_H
