/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SignalExpression.h"
#include "SignalExpressionContext.h"

namespace GeopsyCore {

/*!
  \class SignalExpression SignalExpression.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

bool SignalExpression::isReadOnly() const
{
  return MetaDataFactory::instance()->isReadOnly(_index);
}

QVariant SignalExpression::value(const QString& index) const
{
  TRACE;
  MetaDataIndex i(_index);
  i.setIndex(index);
  return _context->signal()->header(i);
}

void SignalExpression::setValue(const QString& index, const QVariant& val)
{
  TRACE;
  MetaDataIndex i(_index);
  i.setIndex(index);
  _context->signal()->setHeader(i, val);
}

} // namespace GeopsyCore
