/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-24
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SEGYHEADER_H
#define SEGYHEADER_H

#include <QtCore>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     /* set alignment to 1 byte boundary */

  class GEOPSYCORE_EXPORT SEGYHeader
  {
  public:
    void init();

    bool read(QDataStream& s);
    bool write(QDataStream& s);
  private:
    union {
      struct {
        char raw0[3200];
        qint32 raw1[3];
        qint16 raw2[24];
        char raw3[240];
        qint16 raw4[3];
        char raw5[94];
      } raw;
      struct {
        char textualFileHeader[3200];              // Index in SEGY specification (Fortran index)
        qint32 jobIdentification;                  // 3201-3204
        qint32 lineNumber;                         // 3205-3208
        qint32 reelNumber;                         // 3209-3212
        qint16 numberOfDataTracesPerEnsemble;      // 3213-3214
        qint16 numberOfAuxiliaryTracesPerEnsemble; // 3215-3216
        qint16 sampleInterval;                     // 3217-3218 (in microseconds)
        qint16 originalSampleInterval;             // 3219-3220 (in microseconds)
        qint16 numberOfSamplesPerTrace;            // 3221-3222
        qint16 originalNumberOfSamplesPerTrace;    // 3223-3224
        qint16 dataSampleFormat;                   // 3225-3226 (1 to 8)
        qint16 ensembleFold;                       // 3227-3228
        qint16 traceSorting;                       // 3229-3230
        qint16 verticalSum;                        // 3231-3232
        qint16 startSweepFrequency;                // 3233-3234
        qint16 endSweepFrequency;                  // 3235-3236
        qint16 sweepLength;                        // 3237-3238 (in ms)
        qint16 sweepType;                          // 3239-3240
        qint16 sweepTraceChannelNumber;            // 3241-3242
        qint16 startSweepTraceTaperLength;         // 3243-3244
        qint16 endSweepTraceTaperLength;           // 3245-3246
        qint16 taperType;                          // 3247-3248
        qint16 correlatedDataTraces;               // 3249-3250
        qint16 binaryGainRecovered;                // 3251-3252
        qint16 amplitudeRecoveryMethod;            // 3253-3254
        qint16 measurementSystem;                  // 3255-3256
        qint16 impulseSignalPolarity;              // 3257-3258
        qint16 vibratoryPolarity;                  // 3259-3260
        char unassigned0[240];                     // 3261-3500
        qint16 segYRevisionNumber;                 // 3501-3502
        qint16 fixLengthTraceFlag;                 // 3503-3504
        qint16 numberOfExtendedTextualHeaders;     // 3505-3506
        char unassigned1[94];                      // 3507-3600
      } field;
    };
  };

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // SEGYHEADER_H
