/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-24
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "SEGYHeader.h"

namespace GeopsyCore {

  /*!
    \class SEGYHeader SEGYHeader.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
  */
  void SEGYHeader::init()
  {
    TRACE;
    ASSERT(sizeof(SEGYHeader)==3600);
    memset(this, 0, 3600);
    field.dataSampleFormat=5; // IEEE floating point
    // Geopsy currently does not read other header fields.
  }

  bool SEGYHeader::read(QDataStream& s)
  {
    TRACE;
    s.readRawData(raw.raw0, 3200);
    for(int i=0;i<3;i++) s >> raw.raw1[i];
    for(int i=0;i<24;i++) s >> raw.raw2[i];
    s.skipRawData(240);
    for(int i=0;i<3;i++) s >> raw.raw4[i];
    s.skipRawData(94);
    return s.status()==QDataStream::Ok;
  }

  bool SEGYHeader::write(QDataStream& s)
  {
    TRACE;
    if(s.writeRawData(raw.raw0, 3200)!=3200) return false;
    for(int i=0;i<3;i++) s << raw.raw1[i];
    for(int i=0;i<24;i++) s << raw.raw2[i];
    if(s.writeRawData(raw.raw3, 240)!=240) return false;
    for(int i=0;i<3;i++) s << raw.raw4[i];
    if(s.writeRawData(raw.raw5, 94)!=94) return false;
    return true;
  }

} // namespace GeopsyCore
