/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-01-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SEGDHeader.h"

namespace GeopsyCore {

  /*!
    \class SEGDHeader SEGDHeader.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  void SEGDHeader::init()
  {
    TRACE;
    ASSERT(sizeof(SEGDHeader)==64);
    memset(this, 0, 64);
  }

  bool SEGDHeader::read(QDataStream& s)
  {
    TRACE;
    s.readRawData(raw.raw0, 64);
    return s.status()==QDataStream::Ok;
  }

  bool SEGDHeader::write(QDataStream& s)
  {
    TRACE;
    if(s.writeRawData(raw.raw0, 64)!=64) return false;
    return true;
  }


} // namespace GeopsyCore
