/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-04
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MINISEEDSEQUENCE_H
#define MINISEEDSEQUENCE_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT MiniSeedSequence : public XMLClass
  {
  public:
    MiniSeedSequence();

    bool operator==(const MiniSeedSequence& o) const;

    const QString& xml_tagName() const {return xmlMiniSeedSequenceTag;}
    static const QString xmlMiniSeedSequenceTag;

    void setFirstPos(off_t p) {_firstPos=p;}
    void setByteLength(quint32 b) {_byteLength=b;}
    bool add(off_t pos, quint32 byteLength);

    int count() const {return _count;}
    off_t pos(int index) const {return _firstPos+index*_increment;}
    quint32 byteLength() const {return _byteLength;}

    void xml_attributes(XML_ATTRIBUTES_ARGS) const;
    bool xml_setAttributes(XML_SETATTRIBUTES_ARGS);
  protected:

  private:
    off_t _firstPos;
    off_t _increment;
    quint32 _byteLength;
    int _count;
  };

} // namespace GeopsyCore

#endif // MINISEEDSEQUENCE_H

