/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-28
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef METADATAFIELD_H
#define METADATAFIELD_H

#include <QtCore>

#include "MetaDataIndex.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT MetaDataField : public MetaDataIndex
  {
  public:
    MetaDataField() {}
    MetaDataField(const MetaDataIndex& o);
    inline MetaDataField(const MetaDataIndex& o, const QString& t);

    void setTitle(const QString& t) {_title=t;}
    const QString& title() const {return _title;}
  private:
    QString _title;
  };

  inline MetaDataField::MetaDataField(const MetaDataIndex& o, const QString& t)
      : MetaDataIndex(o), _title(t)
  {
  }

} // namespace GeopsyCore

#endif // METADATAFIELD_H
