/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TARGET_H
#define TARGET_H

#include <QGpCoreMath.h>

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT Target : public XMLClass
{
public:
  Target();
  Target(const Target& o);

  bool selected() const {return _selected;}
  void setSelected(bool s) {_selected= s;}

  double misfitWeight() const {return _misfitWeight;}
  void setMisfitWeight(double w) {_misfitWeight= w;}

  double minimumMisfit() const {return _minimumMisfit;}
  void setMinimumMisfit(double m) {_minimumMisfit=m;}

  Misfit::Type misfitType() const {return _misfitType;}
  void setMisfitType(Misfit::Type t) {_misfitType=t;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  bool _selected;
  double _misfitWeight;
  double _minimumMisfit;
  Misfit::Type _misfitType;
};

} // namespace DinverDCCore

#endif // TARGET_H
