/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-01-25
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRADIENTPROFILE_H
#define GRADIENTPROFILE_H

#include <QGpCoreMath.h>
#include <QGpCoreWave.h>

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

  class DINVERDCCORE_EXPORT GradientProfile
  {
  public:
    GradientProfile(int n);
    GradientProfile(const GradientProfile& o);
    virtual ~GradientProfile() {}

    virtual GradientProfile * clone() const=0;

    virtual void setSubLayerCount(int n);
    int subLayerCount() const {return _n;}

    void setTopValue(double v) {_vt=v;}
    double topValue() const {return _vt;}

    virtual bool setGradient(double alpha);
    double gradient() const {return _alpha;}

    virtual bool setBottomValue(double v)=0;
    virtual double bottomValue() const=0;

    void setTopDepth(double z) {_zt=z;}
    double topDepth() const {return _zt;}

    void setBottomDepth(double z) {_zb=z;}
    double bottomDepth() const {return _zb;}

    bool hasValidDepths() const {return _zt<_zb;}
    double thickness() const {return _zb-_zt;}

    virtual void setDepths(int topIndex, Profile& p)=0;
    virtual void setValues(int topIndex, Profile& p)=0;

    virtual void setMinimumTopValue(double value, double depth)=0;
    virtual void setMaximumTopValue(double value, double depth)=0;
    virtual void setMinimumGradient(double value, double depth)=0;
    virtual void setMaximumGradient(double value, double depth)=0;
  protected:
    int _n;
    double _vt, _alpha, _zt, _zb;
  };

} // namespace DinverDCCore

#endif // GRADIENTPROFILE_H

