/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-01-25
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GradientProfile.h"

namespace DinverDCCore {

  /*!
    \class GradientProfile GradientProfile.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  GradientProfile::GradientProfile(int n)
  {
    if(n<1) {
      n=1;
    }
    _n=n;
    _vt=0.0;
    _alpha=0.0;
    _zt=0.0;
    _zb=0.0;
  }

  GradientProfile::GradientProfile(const GradientProfile& o)
  {
    _n=o._n;
    _vt=o._vt;
    _alpha=o._alpha;
    _zt=o._zt;
    _zb=o._zb;
  }

  void GradientProfile::setSubLayerCount(int n)
  {
    if(n!=_n && n>0) {
      _n=n;
    }
  }

  /*!
    Return true if depths must recomputed.
    The default implementation always return false.
  */
  bool GradientProfile::setGradient(double alpha)
  {
    _alpha=alpha;
    return false;
  }

  /*!
    \fn bool GradientProfile::setBottomValue(double v)
    Return true if depths must recomputed.
  */

} // namespace DinverDCCore

