/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-12
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODEL_H
#define MODEL_H

#include "DinverCoreDLLExport.h"
#include "ModelSet.h"

namespace DinverCore {

  class DINVERCORE_EXPORT Model
  {
  public:
    inline Model(const SetIndex& i, ModelSet * parent);
    inline Model(const Model& o);

    bool operator==(const Model& o) const;

    int parameterCount() const {return _parent->parameterCount();}
    const int * data() const {return _parent->model(_index);}
    int value(int index) const {return data()[index];}

    void print() const;
    static void print(int parameterCount, const int * data);
  private:
    SetIndex _index;
    ModelSet * _parent;
  };

  uint qHash(const Model& m);

  inline Model::Model(const SetIndex& i, ModelSet * parent)
  {
    _index=i;
    _parent=parent;
  }

  inline Model::Model(const Model& o)
  {
    _index=o._index;
    _parent=o._parent;
  }

} // namespace DinverCore

#endif // MODEL_H
