/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  ArrayGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-06-13
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PLOTSPACRING_H
#define PLOTSPACRING_H

#include <ArrayCore.h>
#include <SciFigs.h>

#include "ArrayGuiDLLExport.h"

namespace ArrayGui {

  class ARRAYGUI_EXPORT PlotSPACRing : public SPACRing
  {
  public:
    PlotSPACRing();
    PlotSPACRing(const SPACRing& o);

    const Pen& pen() const {return _pen;}
    void setPen(const Pen& p) {_pen=p;}

    bool read(QTextStream& s);
    void write(QTextStream& s) const;
    static void writeHeader(QTextStream& s);
  private:
    Pen _pen;
  };

} // namespace ArrayGui

#endif // PLOTSPACRING_H

