/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  ArrayGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-06-13
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "PlotSPACRing.h"

namespace ArrayGui {

  /*!
    \class PlotSPACRing PlotSPACRing.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  PlotSPACRing::PlotSPACRing()
  {
    _pen.setColor(Qt::red);
    _pen.setWidth(0.6);
  }

  PlotSPACRing::PlotSPACRing(const SPACRing& o)
    : SPACRing(o)
  {
    _pen.setColor(Qt::red);
    _pen.setWidth(0.6);
  }

  bool PlotSPACRing::read(QTextStream& s)
  {
    QString line=s.readLine().simplified();
    if(!line.isEmpty() && line[0]!='#') {
      LineParser lp(line);
      bool ok=true;
      setMinRadius(lp.toDouble(0, ok));
      setMaxRadius(lp.toDouble(1, ok));
      QColor c;
      c.setRed(lp.toInt(2, ok));
      c.setGreen(lp.toInt(3, ok));
      c.setBlue(lp.toInt(4, ok));
      _pen.setColor(c);
      // Unread number of pairs in column 5, left at this place for compatibility
      if(lp.count()>=8) {
        _pen.setWidth(lp.toDouble(6, ok));
        _pen.setLineStyle(Pen::convertLineStyle(lp.toString(7, ok), ok));
      }
      return ok;
    }
    return false;
  }

  void PlotSPACRing::writeHeader(QTextStream& s)
  {
    s << "# MinRadius\tMaxRadius\tRed\tGreen\tBlue\tNum_pairs\tWidth\tStyle" << Qt::endl;
  }

  void PlotSPACRing::write(QTextStream& s) const
  {
    s << minRadius() << "\t"
      << maxRadius() << "\t"
      << _pen.color().red() << "\t"
      << _pen.color().green() << "\t"
      << _pen.color().blue() << "\t"
      << count() << "\t"
      << _pen.width() << "\t"
      << Pen::convertLineStyle(_pen.lineStyle()) << Qt::endl;
  }

} // namespace ArrayGui

