/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-12-19
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "StationPairs.h"
#include "SPACRing.h"

namespace ArrayCore {

  /*!
    \class StationPairs StationPairs.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  StationPairs::StationPairs(const ArraySelection * array)
    : VectorList<StationPair>()
  {
    TRACE;
    int nStations=array->count();
    int nPairs=nStations*(nStations-1)/2;
    resize(nPairs);
    int iPair=0;
    for(int i=nStations-1; i>=0; i--) {
      for(int j=i-1; j>=0; j--) {
        operator[](iPair++).setStations(array, i, j);
      }
    }
    std::sort(begin(), end(), StationPair::lessThan);
  }

  /*!
    Description of destructor still missing
  */
  StationPairs::~StationPairs()
  {
    TRACE;
  }

  VectorList<RingPairs> StationPairs::rings(const SPACParameters * param)
  {
    TRACE;
    VectorList<RingPairs> list;
    int n=param->ringCount();
    for(int i=0; i<n; i++) {
      RingPairs r(param->rings().at(i));
      if(r.setStations(*this)) {
        list.append(r);
      }
    }
    return list;
  }

  VectorList<RingPairs> StationPairs::rings()
  {
    TRACE;
    VectorList<RingPairs> list;
    VectorList<SPACRing> spacRings=SPACRing::autoRings(*this);
    int n=spacRings.count();
    for(int i=0; i<n; i++) {
      RingPairs r(spacRings.at(i));
      if(r.setStations(*this)) {
        list.append(r);
      }
    }
    return list;
  }

} // namespace ArrayCore

