/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-10-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SENSORORIENTATIONTASKMANAGER_H
#define SENSORORIENTATIONTASKMANAGER_H

#include "FKTaskManager.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class CrossSpectrumSplit;

  class ARRAYCORE_EXPORT SensorOrientationTaskManager : public FKTaskManager
  {
  public:
    SensorOrientationTaskManager(const ArraySelection * array);
    ~SensorOrientationTaskManager();

    bool setParameters(const ArrayParameters * param);
    FKCache * gridCache() {return _gridCache;}
    const bool * selectedStations() const {return _selectedStations;}

    void addObservation(int frequencyIndex, CrossSpectrumSplit * split);
    const VectorList<CrossSpectrumSplit *> * observations(int frequencyIndex) {return _observations+frequencyIndex;}
    void addResult(double frequency, const Vector<double>& position);
    bool save(QString fileName, const QString& log);
  protected:
    LoopWorker * newWorker();
  private:
    void selectStations();

    QMutex _observationMutex;
    VectorList<CrossSpectrumSplit *> * _observations;
    QMutex _resultMutex;
    VectorList<DoubleMatrix> _results;
    bool * _selectedStations;
  };

} // namespace ArrayCore

#endif // SENSORORIENTATIONTASKMANAGER_H

