/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-01-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef OMNIFKVERTICAL_H
#define OMNIFKVERTICAL_H

#include "HRFKVertical.h"

namespace ArrayCore {

#if 0
  class ARRAYCORE_EXPORT OmniFKVertical : public HRFKVertical
  {
  public:
    OmniFKVertical(FKCache * cache)
      : HRFKVertical(cache) {}

    virtual void setGrid(FKGridSearch * g, double step, double size);
    void setAngleGrid();
    virtual bool initGrid(int n);
    virtual void initGrid(const Point& kell, int index);

    virtual double value(const Point& kell, int index) const;
    virtual double value(const Point& kell) const;

    virtual bool isOnLimit(const Point& k, double frequency) const;
    virtual Point2D waveNumber(const Point& k) const {return Point2D(k.x(), 0.0);}
  protected:
    virtual AbstractFunction * createAngleFunction() const;

    class Angle : public AbstractFKFunction
    {
    public:
      Angle(FKCache * cache)
        : AbstractFKFunction(cache) {}

      virtual void resetCrossSpectrum() {}
      virtual void addCrossSpectrum() {}
      virtual void meanCrossSpectrum(int) {}
      virtual bool invertCrossSpectrum() {return false;}

      void setWaveNumber(const Point& kell) {_kell=kell;}
      const Point& waveNumber() const {return _kell;}

      virtual double value(const Point& a, int index) const;
      virtual double value(const Point& a) const;
    protected:
      Point _kell;
    };
  private:
    mutable AngleSearch _grid;
  };
#endif
} // namespace ArrayCore

#endif // OMNIFKVERTICAL_H

