/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-30
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ORAPARAMETERS_H
#define ORAPARAMETERS_H

#include "ArrayParameters.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ORAParameters : public ArrayParameters
  {
    TRANSLATIONS("ORAParameters")
  public:
    ORAParameters();
    ORAParameters(const ORAParameters& o);

    AbstractParameters * clone() const {return new ORAParameters(*this);}

    QString outputName(const QString&) const {return "/tmp/toto";}
  };

} // namespace ArrayCore

#endif // ORAPARAMETERS_H

