/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-02-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef KNULLSOLVER_H
#define KNULLSOLVER_H

#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"
#include "FKParameters.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT TheoreticalFKNull : public TheoreticalFK
  {
  public:
    TheoreticalFKNull(const VectorList<Point2D>& stations)
      : TheoreticalFK(stations), _k(2, 0.0) {}

    void setGridStep(double s) {_gridStep=s;}

    inline double value(const Vector<int>& index) const;
    double value(Vector<double>& k) const {return 1.0/TheoreticalFK::value(k);}
  private:
    double _gridStep;
    mutable PrivateVector<double> _k;
  };

  inline double TheoreticalFKNull::value(const Vector<int>& index) const
  {
    _k[0]=index[0]*_gridStep;
    _k[1]=index[1]*_gridStep;
    return 1.0/TheoreticalFK::value(_k);
  }

  class ARRAYCORE_EXPORT KNullSolver
  {
  public:
    KNullSolver(const VectorList<Point2D>& stations);
    ~KNullSolver();

    void collect(const FKParameters& param, double threshold);
    const VectorList<Point2D>& points() const { return _points;}
  private:
    static bool lengthLessThan(const Point2D& p1, const Point2D& p2);

    TheoreticalFKNull * _function;
    VectorList<Point2D> _points;
  };

} // namespace ArrayCore

#endif // KNULLSOLVER_H

