/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKVertical_H
#define HRFKVertical_H

#include "ConvFKVertical.h"
#include "FKGradientSearch.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKVertical : public ConvFKVertical
  {
  public:
    HRFKVertical(FKCache * cache);
    ~HRFKVertical();

    bool invertCrossSpectrum();

    double value(const Vector<int>& index) const;
    double value(Vector<double>& k) const;
    void gradient(const Vector<double>&, Vector<double>& grad) const;

    bool remove(const Vector<double>& k, FKPeaks::Value& val);

    //virtual void setGradient(FKPower& p) const;
    //virtual void setHessian(FKPower& p) const;

    //virtual void setGradient(const Point& k, FKPower& p) const;
    //virtual void setHessian(const Point& k, FKPower& p) const;

    double wavenumberNormalizedConcavity(const Vector<double>& k) const;
  protected:
    ComplexMatrix _originalCrossSpectrum;
  private:
    //mutable qint64 _countGrid, _countFree;
    void testKDerivatives(const Vector<double>& k) const;
  };

} // namespace ArrayCore

#endif // HRFKVertical_H
