/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-10
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKDIRECTRAYLEIGHALL_H
#define HRFKDIRECTRAYLEIGHALL_H

#include "HRFKDirectRayleigh.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class DirectEllipticityEngine;

  class ARRAYCORE_EXPORT HRFKDirectRayleighAll : public HRFKDirectRayleigh
  {
  public:
    HRFKDirectRayleighAll(FKCache * cache)
      : HRFKDirectRayleigh(cache) {}
    ~HRFKDirectRayleighAll();

    void initialize(const FKParameters& param);

    double value(const Vector<int>& index) const;
    double value(Vector<double>& kell) const;
    double valueFixed(const Vector<double>& kell) const;
    double concavity(const Vector<double>& kell, int axis) const;

    void setFunctionValue(Attributes& a) const;
    void setFunctionDerivatives(Attributes& a) const;

    double wavenumberNormalizedConcavity(const Vector<double>& kell) const;

    bool remove(const Vector<double>& kell, FKPeaks::Value& val);
  private:
    inline void commitEvaluationStat() const;
    inline void maximumEllipticity() const;
    inline void gridMaximumEllipticity() const;
  };

} // namespace ArrayCore

#endif // HRFKDIRECTRAYLEIGHALL_H

