/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-05-15
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRFKDIRECTRADIAL_H
#define HRFKDIRECTRADIAL_H

#include "HRFKVertical.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT HRFKDirectRadial : public HRFKVertical
  {
  public:
    HRFKDirectRadial(FKCache * cache) : HRFKVertical(cache) {}

    void initialize(const FKParameters& param);
    void addCrossSpectrum();
    void addIncoherentNoise(double horizontal, double );

    double value(const Vector<int>& index) const;
    double value(Vector<double>& k) const;
  };

} // namespace ArrayCore

#endif // HRFKDIRECTRADIAL_H

