/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-02-02
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HRELLIPTICITYENGINE_H
#define HRELLIPTICITYENGINE_H

#include "AbstractEllipticityEngine.h"
#include "HRFKRayleigh.h"
#include "HRFKVertical.h"
#include "HRFKRadial.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class HRFKRayleighRadial;
  class HRFKRayleighVertical;

  class ARRAYCORE_EXPORT HREllipticityEngine: public AbstractEllipticityEngine
  {
  public:
    HREllipticityEngine(FKCache * cache, const FKParameters& param);
    ~HREllipticityEngine();

    double radialPower(Vector<double>& kell,
                       FKCrossSpectrum * crossSpectrum);
    double radialWavenumberNormalizedConcavity(Vector<double>& kell);
    double radialConcavity(Vector<double>& kell, int axis);
    double verticalPower(Vector<double>& kell,
                         FKCrossSpectrum * crossSpectrum);
    double verticalWavenumberNormalizedConcavity(Vector<double>& kell);
    double verticalConcavity(Vector<double>& kell, int axis);
  protected:
    HRFKRayleighRadial * _rayleighRadial;
    HRFKRayleighVertical * _rayleighVertical;
  };

} // namespace ArrayCore

#endif // HRELLIPTICITYENGINE_H

