/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-06-27
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HRFKDirectRayleighRadial.h"
#include "HRFKDirectRayleighVertical.h"
#include "HRDirectEllipticityEngine.h"
#include "HRFKDirectRadial.h"

namespace ArrayCore {

  /*!
    \class HRDirectEllipticityEngine HRDirectEllipticityEngine.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    \class HRDirectEllipticityEngine HRDirectEllipticityEngine.h
    \brief
  */
  HRDirectEllipticityEngine::HRDirectEllipticityEngine(FKCache * cache, const FKParameters& param)
    : AbstractEllipticityEngine(param)
  {
    _vertical=new HRFKVertical(cache);
    _vertical->initialize(param);
    _radial=new HRFKDirectRadial(cache);
    _radial->initialize(param);

    _rayleighRadial=new HRFKDirectRayleighRadial(cache);
    _rayleighRadial->initialize(param);
    _rayleighVertical=new HRFKDirectRayleighVertical(cache);
    _rayleighVertical->initialize(param);
  }

  HRDirectEllipticityEngine::~HRDirectEllipticityEngine()
  {
    delete _rayleighRadial;
    delete _rayleighVertical;
  }

  double HRDirectEllipticityEngine::radialPower(Vector<double>& kell,
                                                FKCrossSpectrum * crossSpectrum)
  {
    _rayleighRadial->setCrossSpectrum(crossSpectrum->matrix());
    return _rayleighRadial->value(kell);
  }

  double HRDirectEllipticityEngine::radialWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    return _rayleighRadial->wavenumberNormalizedConcavity(kell);
  }

  double HRDirectEllipticityEngine::radialConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighRadial->concavity(kell, axis);
  }

  double HRDirectEllipticityEngine::verticalPower(Vector<double>& kell,
                                                  FKCrossSpectrum * crossSpectrum)
  {
    _rayleighVertical->setCrossSpectrum(crossSpectrum->matrix());
    return _rayleighVertical->value(kell);
  }

  double HRDirectEllipticityEngine::verticalWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    return _rayleighVertical->wavenumberNormalizedConcavity(kell);
  }

  double HRDirectEllipticityEngine::verticalConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighVertical->concavity(kell, axis);
  }

} // namespace ArrayCore

