/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-03-03
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FKFUNCTIONPLOT_H
#define FKFUNCTIONPLOT_H

#include <QGpCoreMath.h>

#include "AbstractFKFunction.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT FKFunctionPlot : public FunctionPlot
  {
  public:
    FKFunctionPlot(AbstractFKFunction * f=nullptr);
    ~FKFunctionPlot();

    enum Mode {BeamPower, InverseBeamPower,
               Ellipticity, FixedEllipticity,
               GradientDirection, Concavity, StepDirection,
               CrossSpectralMatrix
              };

    void setMode(Mode m) {_mode=m;}
    Mode mode() const {return _mode;}

    void setFixedEllipticity(double xi) {_x[2]=xi;}

    void setFunction(AbstractFKFunction * f) {FunctionPlot::setFunction(f);}
    inline AbstractFKFunction * function() const;

    double value(double x, double y) const;
  private:
    Mode _mode;
  };

  inline AbstractFKFunction * FKFunctionPlot::function() const
  {
    return static_cast<AbstractFKFunction *>(FunctionPlot::function());
  }

} // namespace ArrayCore

#endif // FKFUNCTIONPLOT_H

