/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-06-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class CrossSpectrum CrossSpectrum.h
    \brief Brief description of class still missing

    Kept for future use if redondant Fourier transforms should still be avoided.
  */

  /*!
    Description of constructor still missing
  */
  CrossSpectrum::CrossSpectrum()
    : CacheItem()
  {
    _rotateStepCount=0;
    _rayleighCrossSpectra=nullptr;
    _loveCrossSpectra=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  CrossSpectrum::~CrossSpectrum()
  {
    delete [] _rayleighCrossSpectra;
    delete [] _loveCrossSpectra;
  }

  /*!
    All matrices are square and complex
  */
  qint64 CrossSpectrum::dataSize() const
  {
    int s=0;
    int n;
    if(_rayleighCrossSpectra) {
      n=_rayleighCrossSpectra[0].columnCount();
      s+=_rotateStepCount*n*n;
    }
    if(_loveCrossSpectra) {
      n=_loveCrossSpectra[0].columnCount();
      s+=_rotateStepCount*n*n;
    }
    n=_rayleighCrossSpectrum.columnCount();
    s+=n*n;
    n=_loveCrossSpectrum.columnCount();
    s+=n*n;
    s*=sizeof(Complex);
    return s;
  }

  bool CrossSpectrum::isAllocated() const
  {
    return _rayleighCrossSpectra ||
        _loveCrossSpectra ||
        _rayleighCrossSpectrum.columnCount()>0 ||
        _loveCrossSpectrum.columnCount()>0;
  }

  bool CrossSpectrum::allocate() const
  {
    return true;
  }

  void CrossSpectrum::free() const
  {
    delete [] _rayleighCrossSpectra;
    _rayleighCrossSpectra=nullptr;
    delete [] _loveCrossSpectra;
    _loveCrossSpectra=nullptr;
    _rayleighCrossSpectrum=ComplexMatrix();
    _loveCrossSpectrum=ComplexMatrix();
  }

  bool CrossSpectrum::load(QDir&) const
  {
    return false;
  }

  bool CrossSpectrum::save(QDir&) const
  {
    return false;
  }

} // namespace ArrayCore

