/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-12
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ASYNCPARAMETERS_H
#define ASYNCPARAMETERS_H

#include "FKParameters.h"
#include "BlockAveragingParameters.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT AsyncParameters : public FKParameters
  {
  public:
    AsyncParameters();
    AsyncParameters(const AsyncParameters& o);

    virtual AbstractParameters * clone() const {return new AsyncParameters(*this);}

    BlockAveragingParameters& blockAveraging() {return _blockAveraging;}
    const BlockAveragingParameters& blockAveraging() const {return _blockAveraging;}
    void setBlockAveraging(const BlockAveragingParameters& b) {_blockAveraging=b;}

    double damping() const {return _damping>0.0 ? _damping : 0.0;}
    void setDamping(double d) {_damping=d;}

    virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    virtual int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    virtual int totalKeywordCount(PARAMETERS_TOTALKEYWORDCOUNT_ARGS) const;
    virtual bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    BlockAveragingParameters _blockAveraging;
    double _damping;
  };

} // namespace ArrayCore

#endif // ASYNCPARAMETERS_H

