/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-13
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIVEFKTASK_H
#define ACTIVEFKTASK_H

#include "ArrayTask.h"
#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ARRAYCORE_EXPORT ActiveFKTask : public ArrayTask
  {
  public:
    ActiveFKTask(ArrayTaskManager * manager,
                 int taskIndex,
                 const ArraySelection * array,
                 const SparseKeepSignal * keep,
                 const ArrayParameters * param,
                 const SeismicEvent * source)
        : ArrayTask(manager, taskIndex, array, keep, param), _source(source) {}

    void init();
  private:
    const SeismicEvent * _source;
  };

} // namespace ArrayCore

#endif // ACTIVEFKTASK_H

