/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-07-22
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ActiveConvEllipticityEngine.h"
#include "ConvFKRadial.h"
#include "ActiveConvFKRayleighRadial.h"
#include "ActiveConvFKRayleighVertical.h"
#include "FKCrossSpectrum.h"

namespace ArrayCore {

  /*!
    \class ActiveConvEllipticityEngine ActiveConvEllipticityEngine.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ActiveConvEllipticityEngine::ActiveConvEllipticityEngine(FKCache * cache, const FKParameters& param)
    : AbstractEllipticityEngine(param)
  {
    _vertical=new ConvFKVertical(cache);
    _vertical->initialize(param);
    _radial=new ConvFKRadial(cache);
    _radial->initialize(param);

    _rayleighRadial=new ActiveConvFKRayleighRadial(cache);
    _rayleighRadial->initialize(param);
    _rayleighVertical=new ActiveConvFKRayleighVertical(cache);
    _rayleighVertical->initialize(param);
  }

  /*!
    Description of destructor still missing
  */
  ActiveConvEllipticityEngine::~ActiveConvEllipticityEngine()
  {
    _rayleighRadial->clearSharedSteering();
    _rayleighVertical->clearSharedSteering();
    delete _rayleighRadial;
    delete _rayleighVertical;
  }

  void ActiveConvEllipticityEngine::setCrossSpectrum(FKCrossSpectrum * s)
  {
    _rayleighRadial->setCrossSpectrum(s);
    _rayleighVertical->setCrossSpectrum(s);
  }

  void ActiveConvEllipticityEngine::shareSteering(const ActiveConvFKRayleigh * ref)
  {
    _rayleighRadial->shareSteering(ref);
    _rayleighVertical->shareSteering(ref);
  }

  double ActiveConvEllipticityEngine::radialPower(Vector<double>& kell,
                                                  FKCrossSpectrum * crossSpectrum)
  {
    _rayleighRadial->setCrossSpectrum(crossSpectrum->matrix());
    return _rayleighRadial->value(kell);
  }

  double ActiveConvEllipticityEngine::radialWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    Q_UNUSED(kell);
    TODO_WARNING;
    return 0.0;
  }

  double ActiveConvEllipticityEngine::radialConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighRadial->concavity(kell, axis);
  }

  double ActiveConvEllipticityEngine::verticalPower(Vector<double>& kell,
                                                    FKCrossSpectrum * crossSpectrum)
  {
    _rayleighVertical->setCrossSpectrum(crossSpectrum->matrix());
    return _rayleighVertical->value(kell);
  }

  double ActiveConvEllipticityEngine::verticalWavenumberNormalizedConcavity(Vector<double>& kell)
  {
    Q_UNUSED(kell);
    TODO_WARNING;
    return 0.0;
  }

  double ActiveConvEllipticityEngine::verticalConcavity(Vector<double>& kell, int axis)
  {
    return _rayleighVertical->concavity(kell, axis);
  }

} // namespace ArrayCore

