/***************************************************************************
**
**  This file is part of warangps.
**
**  warangps is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  warangps is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-28
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GpsTableModel.h"
#include "GpsStation.h"

/*!
  \class GpsTableModel GpsTableModel.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
GpsTableModel::GpsTableModel(QObject * parent)
    : QAbstractTableModel(parent)
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
GpsTableModel::~GpsTableModel()
{
  TRACE;
}

void GpsTableModel::setStations(QList<GpsStation *> * stations)
{
  TRACE;
  beginResetModel();
  _stations=stations;
  endResetModel();
}

void GpsTableModel::resetGpsResults()
{
  TRACE;
  emit dataChanged(createIndex(0,3), createIndex(_stations->count(),15));
}

int GpsTableModel::rowCount(const QModelIndex & ) const
{
  TRACE;
  return _stations->count();
}

/*!
  Currently return only 1 but may evolve in the future
*/
int GpsTableModel::columnCount(const QModelIndex &) const
{
  TRACE;
  return 14;
}

QVariant GpsTableModel::data(const QModelIndex &index, int role) const
{
  TRACE;
  if( !index.isValid()) return QVariant();
  GpsStation * stat=_stations->at(index.row());
  switch (role) {
  case Qt::DisplayRole:
    switch(index.column()) {
    case 0:
      return stat->name();
    case 1:
      return QString::number(stat->longitude().mean(),'f',7);
    case 2:
      return QString::number(stat->latitude().mean(),'f',7);
    case 3:
      return QString::number(stat->altitude().mean(),'f',3);
    case 4:
      return QString::number(stat->longitude().stddev(),'f',7);
    case 5:
      return QString::number(stat->latitude().stddev(),'f',7);
    case 6:
      return QString::number(stat->altitude().stddev(),'f',3);
    case 7:
      return QString::number(stat->longitude().count());
    case 8:
      return QString::number(stat->horizontalAccuracy(),'f',3);
    case 9:
      return QString::number(stat->horizontalDop(),'f',1);
    case 10:
      return QString::number(stat->northingDop(),'f',1);
    case 11:
      return QString::number(stat->eastingDop(),'f',1);
    case 12:
      return QString::number(stat->sateliteCount());
    case 13:
      return stat->solution();
    default:
      return QVariant();
    }
  case Qt::ToolTipRole:
    return stat->info();
  default:
    return QVariant();
  }
}

bool GpsTableModel::setData (const QModelIndex & index, const QVariant & value, int role)
{
  TRACE;
  if(index.column()==1 && role==Qt::EditRole) {
    _stations->at(index.row())->setOperatorName(value.toString());
    return true;
  } else {
    return false;
  }
}
QVariant GpsTableModel::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(role!=Qt::DisplayRole) return QVariant();
  if(orientation==Qt::Horizontal) {
    switch (section) {
    case 0: return tr("Station");
    case 1: return tr("Long. (aver)");
    case 2: return tr("Lat. (aver)");
    case 3: return tr("Alt. (aver)");
    case 4: return tr("Long. (dev)");
    case 5: return tr("Lat. (dev)");
    case 6: return tr("Alt. (dev)");
    case 7: return tr("Count");
    case 8: return tr("H Accuracy");
    case 9: return tr("H DOP");
    case 10: return tr("N DOP");
    case 11: return tr("E DOP");
    case 12: return tr("Satelites");
    case 13: return tr("Solution");
    default: return QVariant();
    }
  } else {
    return section + 1;;
  }
}

Qt::ItemFlags GpsTableModel::flags(const QModelIndex & index) const
{
  if(_stations->at(index.row())->isAvailable()) {
    return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
  } else {
    return 0;
  }
}
