/***************************************************************************
**
**  This file is part of warangps.
**
**  warangps is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  warangps is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GPSSTATION_H
#define GPSSTATION_H

#include <QtNetwork>
#include <QGpCoreMath.h>
#include <WaranCore.h>

class GpsStation : public QObject
{
  Q_OBJECT
public:
  GpsStation();
  ~GpsStation();

  QString name() const {return _name;}
  void setName(QString n) {_name=n;}

  QString operatorName() const {return _operatorName;}
  void setOperatorName(QString o) {_operatorName=o;}

  QString hostName() const {return _hostName;}
  void setHostName(QString hn) {_hostName=hn;}

  quint16 port() const {return _port;}
  void setPort(quint16 p) {_port=p;}

  QString solution() const;
  const QString& info() const {return _info;}
  const Statistics& longitude() const {return _longitude;}
  const Statistics& latitude() const {return _latitude;}
  const Statistics& altitude() const {return _altitude;}
  double horizontalAccuracy() const {return _fix.horizontalAccuracy()*1e-3;}
  double horizontalDop() const {return _fix.horizontalDop()*1e-2;}
  double northingDop() const {return _fix.northingDop()*1e-2;}
  double eastingDop() const {return _fix.eastingDop()*1e-2;}
  int sateliteCount() const {return _fix.sateliteCount();}
  const Point& coordinates() const {return _coordinates;}

  bool isAvailable();

  void startBroadcast();
  void stopBroadcast();

  enum Mode {Track, Stack};
  void setMode(Mode m);
  Mode mode() const {return _mode;}
private slots:
  void bytesAvailable();
  void justConnected();
signals:
  void modeChanged();
private:
  bool match(const char * buffer, int& bytesRead, int bytesCount, const char * string);
  int readInteger(const char * buffer, int& bytesRead, int bytesCount, bool& ok);
  int bytesAvailable(const char * buffer, int bytesCount);
  bool parseFix(const char * data, int bytesCount);

  QString _name;
  QString _hostName;
  quint16 _port;
  QString _operatorName;
  Statistics _longitude;
  Statistics _latitude;
  Statistics _altitude;
  GpsFix _fix;
  Point _coordinates;
  Mode _mode;
  QString _info;
  QTcpSocket _socket;
  QGpCoreTools::DynamicBuffer _socketBuffer;
  unsigned char _index;
};

#endif // GPSSTATION_H

