/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-02-08
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SYSTEMLINK_H
#define SYSTEMLINK_H

#include "DaemonLink.h"

class SystemLink : public DaemonLink
{
  Q_OBJECT
public:
  SystemLink(Station * station);

  void powerOff();
  void reboot();
  void diskSpace();
  void temperature();
  void battery();
  void clearUsb();
  void comments();
  void addComment(const QString& c);

  void highRateRefresh();
protected:
  virtual void connected();
  virtual int bytesAvailable(const char * buffer, int bytesCount);
private slots:
  void refreshVariableParameters();
private:
  void diskSpace(const char * buffer, int bytesRead, int bytesCount);
  bool comments(const char * buffer, int& bytesRead, int bytesCount);
  void halting(const char *, int, int);

  QTimer _refresh;
};

#endif // SYSTEMLINK_H
