/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-13
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REALTIMEARRAYMANAGER_H
#define REALTIMEARRAYMANAGER_H

#include <ArrayCore.h>

#include "ArrayTask.h"
#include "RealTimeArrayProcess.h"
#include "RealTimeHistogram.h"

class RealTimeArrayManager : public QObject
{
  Q_OBJECT
public:
  RealTimeArrayManager(ArrayStations * array);
  ~RealTimeArrayManager();

  void setSamplingParameters(const SamplingParameters& p);
  void setfrequencyBandwidth(double fbw);
  void setWindowLenght(double l);
  void setKmin(double k);
  void setKmax(double k);

  void setMaximumTime(const DateTime& t);
  const DateTime& maximumTime() const {return _globalRange.end();}

  void start();
  void stop();
  bool isActive() const {return _active;}
  void createTasks();

  IrregularGrid2D fkDispersion() const {return _fkDispersion;}
  IrregularGrid2D hrfkDispersion() const {return _hrfkDispersion;}
  IrregularGrid2D spacDispersion() const {return _spacDispersion;}
signals:
  void queueChanged(int size);
private:
  friend class RealTimeArrayProcess;
  //void addTask(ArrayTask * t);
  //ArrayTask * takeTask();
  //void clearTasks();

  ArrayStations * _array;
  TimeRange _globalRange;
  QVector<DateTime> _lastFrequencyTimes;

  double _frequencyBandwidth;
  SamplingParameters _samplingParameters;
  WindowingParameters _windowingParameters;
  QVector<GaussianFrequencyBand> _bands;

  Mutex _mutex;
  QWaitCondition _event;
  bool _active;
  //QQueue<ArrayTask *> _tasks;
  QList<RealTimeArrayProcess *> _threads;

  RealTimeHistogram _fkDispersion, _hrfkDispersion, _spacDispersion;
};

#endif // REALTIMEARRAYMANAGER_H
