/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-18
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef NETWORKPARAMETERS_H
#define NETWORKPARAMETERS_H

#include <QGpCoreTools.h>

class NetworkParameters: public AbstractParameters
{
public:
  NetworkParameters();
  NetworkParameters(const NetworkParameters& o);

  virtual AbstractParameters * clone() const {return new NetworkParameters(*this);}

  const QString& unitList() const {return _unitList;}
  void setUnitList(const QString& u) {_unitList=u;}

  const QString& acquisitionUnitPrefix() const {return _acquisitionUnitPrefix;}
  void setAcquisitionUnitPrefix(const QString& a) {_acquisitionUnitPrefix=a;}

  const QString& repeaterUnitPrefix() const {return _repeaterUnitPrefix;}
  void setRepeaterUnitPrefix(const QString& a) {_repeaterUnitPrefix=a;}

  const QString& processingUnitName() const {return _processingUnitName;}
  void setProcessingUnitName(const QString& p) {_processingUnitName=p;}

  void save();
  void restore();
private:
  QString _unitList;
  QString _acquisitionUnitPrefix;
  QString _repeaterUnitPrefix;
  QString _processingUnitName;
};

#endif // NETWORKPARAMETERS_H
