/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-11-23
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CUBELINK_H
#define CUBELINK_H

#include "DaemonLink.h"

class CubeLink : public DaemonLink
{
  Q_OBJECT
public:
  CubeLink(Station * station);

  void start();
  void stop();
  void setFrequency(double f);
  void setGains(int hard, int soft);

  void highRateRefresh();
protected:
  virtual void connected();
  virtual int bytesAvailable(const char * buffer, int bytesCount);
private slots:
  void refreshVariableParameters();
private:
  void requestParameters();
  void frequency(const char * buffer, int bytesRead, int bytesCount);
  void hardwareGain(const char * buffer, int bytesRead, int bytesCount);
  void numberOfBits(const char * buffer, int bytesRead, int bytesCount);
  void state(const char * buffer, int bytesRead, int bytesCount);

  QTimer _refresh;
};

#endif // CUBELINK_H
