/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreMath.h>

#include "Sample.h"

/*!
  \class Sample Sample.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

Sample::Sample()
{
  _frequency=0.0;
  _autocorr=0.0;
  _ring=0;
}

Sample::Sample(const Sample& s)
{
  _time=s._time;
  _frequency=s._frequency;
  _autocorr=s._autocorr;
  _ring=s._ring;
}

/*!
  Read and parse next available not blank and not starting with '#',
  and containing \a pattern. Non-valid samples are ignored.
*/
bool Sample::read(const QString& line)
{
  TRACE;
  bool ok=true;
  LineParser lp(line);
  _time.fromString(lp.toString(0, ok));
  _frequency=lp.toDouble(1, ok);
  _ring=lp.toInt(3, ok);
  _autocorr=lp.toDouble(4, ok);
  bool valid=(lp.toInt(5, ok)==1);
  if(ok) {
    return valid;
  } else {
    App::log(tr("Error parsing line '%1'\n").arg(line));
    return false;
  }
}


void Sample::write(QTextStream& s, const QString& polarization) const
{
  TRACE;
  s <<  _time.toString() << " "
     << _frequency << " "
     << polarization << " "
     << _ring << " "
     << _autocorr << " 1\n";
}


