/***************************************************************************
**
**  This file is part of screenpicker.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-07-15
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QtGui>

#include "MouseGrab.h"

/*!
  \class MouseGrab MouseGrab.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MouseGrab::MouseGrab(QWidget * parent)
  : QWidget(parent)
{
  TRACE;
  setupUi(this);
  stopButton->setEnabled(false);
  _stream=nullptr;
  _count=0;
  Application::instance()->setStream(log , QThread::currentThread());
}

/*!
  Description of destructor still missing
*/
MouseGrab::~MouseGrab()
{
  TRACE;
  log->remove();
  releaseMouse();
  closeStream();
}

void MouseGrab::closeStream()
{
  TRACE;
  if(_stream) {
    delete _stream->device();
    delete _stream;
  }
}

void MouseGrab::on_startButton_clicked()
{
  TRACE;
  QString fileName=Message::getSaveFileName(tr("Save picks"));
  if(!fileName.isEmpty()) {
    QFile * f=new QFile(fileName);
    if(!f->open(QIODevice::WriteOnly)) {
      Message::warning(MSG_ID, tr("Save picks"), tr("Cannot open file %1").arg(fileName));
      delete f;
    } else {
      App::log(tr("Saving to file %1\n").arg(fileName));
      closeStream();
      _stream=new QTextStream(f);
      grabMouse();
      QCursor c(QPixmap(":cross.png"));
      c.setPos(15, 15);
      setCursor(c);
      startButton->setEnabled(false);
      stopButton->setEnabled(true);
      if(!referenceSystemEdit->isCheckable() || referenceSystemEdit->isChecked()) {
        _realMinimumX=realMinimumXEdit->text().toDouble();
        _realMaximumX=realMaximumXEdit->text().toDouble();
        _realMinimumY=realMinimumYEdit->text().toDouble();
        _realMaximumY=realMaximumYEdit->text().toDouble();
        _xLogScale=xLogScaleEdit->isChecked();
        _yLogScale=yLogScaleEdit->isChecked();
        _count=0;
        App::log(tr("Setting reference points...\n"
                    "  Click on minimum X\n"));
      } else {
        _count=4;
        App::log(tr("Re-using existing reference system\n"
                    "Digitalization of the curve...\n"));
      }
    }
  }
}

/*!
  Description of destructor still missing
*/
void MouseGrab::mouseReleaseEvent(QMouseEvent * event)
{
  TRACE;
  if(stopButton->geometry().contains(event->pos())) {
    releaseMouse();
    QCursor c(Qt::ArrowCursor);
    setCursor(c);
    event->ignore();
    startButton->setEnabled(true);
    stopButton->setEnabled(false);
  } else {
    if(event->button()==Qt::LeftButton) {
      double x=event->globalX();
      double y=event->globalY();
      switch(_count) {
      case 0:
        _screenMinimumX=x;
        App::log(tr("    minimum X=%1\n"
                    "  Click on maximum X\n").arg(x));
        break;
      case 1:
        _screenMaximumX=x;
        App::log(tr("    maximum X=%1\n"
                    "  Click on minimum Y\n").arg(x));
        break;
      case 2:
        _screenMinimumY=y;
        App::log(tr("    minimum Y=%1\n"
                    "  Click on maximum Y\n").arg(y));
        break;
      case 3:
        _screenMaximumY=y;
        App::log(tr("    maximum Y=%1\n"
                    "  Reference points set\n"
                    "Digitalization of the curve...\n").arg(y));
        referenceSystemEdit->setCheckable(true);
        referenceSystemEdit->setChecked(false);
        break;
      default:
        App::log(tr("point (%1): %2 %3 --> ").arg(_count-3).arg(x).arg(y));
        if(_xLogScale) {
          x=::exp(::log(_realMinimumX)+(x-_screenMinimumX)/
                  (_screenMaximumX-_screenMinimumX)*(::log(_realMaximumX/_realMinimumX)));
        } else {
          x=_realMinimumX+(x-_screenMinimumX)/
              (_screenMaximumX-_screenMinimumX)*(_realMaximumX-_realMinimumX);
        }
        if(_yLogScale) {
          y=::exp(::log(_realMinimumY)+(y-_screenMinimumY)/
                  (_screenMaximumY-_screenMinimumY)*(::log(_realMaximumY/_realMinimumY)));
        } else {
          y=_realMinimumY+(y-_screenMinimumY)/
              (_screenMaximumY-_screenMinimumY)*(_realMaximumY-_realMinimumY);
        }
        (*_stream) << x << " " << y << endl;
        App::log(tr("%1 %2\n").arg(x).arg(y));
        break;
      }
      _count++;
    }
    event->accept();
  }
}
