/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-06-27
**  Copyright: 2016
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TASKMANAGER_H
#define TASKMANAGER_H

#include <QGpCoreTools.h>

#include "Parameters.h"

class TaskManager : public ParallelTaskManager
{
public:
  TaskManager(const StationList * stations);
  ~TaskManager();

  void setTimeWindows(TimeRangeList * r);
  bool setParameters(Parameters * p);
  void setTasks();

  const Parameters * parameters() const {return _param;}
  const StationList * stations() const {return _stations;}
  const TimeRangeList * timeWindows() const {return _timeWindows;}

  void addResult(int resIndex, int winIndex, int freqIndex,
                 double coherence, double phase, double amplitude) const;

  const IrregularGrid2D& coherenceGrid(int station) const {return _coherence[station];}
  const IrregularGrid2D& phaseGrid(int station) const {return _phase[station];}
  const IrregularGrid2D& amplitudeGrid(int station) const {return _amplitude[station];}
protected:
  LoopWorker * newWorker();
  ParallelTask * createTask(int taskIndex);
private:
  void setGridCoordinates(IrregularGrid2D& g, const DateTime& refTime);

  const Parameters * _param;
  const StationList * _stations;
  const TimeRangeList * _timeWindows;

  mutable Mutex _gridMutex;
  IrregularGrid2D *_coherence;
  IrregularGrid2D *_phase;
  IrregularGrid2D *_amplitude;
};

#endif // TASKMANAGER_H

