/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-06-27
**  Copyright: 2016
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TaskManager.h"
#include "Worker.h"

/*!
  \class TaskManager TaskManager.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
TaskManager::TaskManager(const StationList * stations)
  : ParallelTaskManager()
{
  TRACE;
  _timeWindows=nullptr;
  _param=nullptr;
  _stations=stations;
  int n=_stations->count()-1;
  _coherence=new IrregularGrid2D[n];
  _phase=new IrregularGrid2D[n];
  _amplitude=new IrregularGrid2D[n];
}

/*!
  Description of destructor still missing
*/
TaskManager::~TaskManager()
{
  TRACE;
  delete [] _coherence;
  delete [] _phase;
  delete [] _amplitude;
}

void TaskManager::setGridCoordinates(IrregularGrid2D& g, const DateTime& refTime)
{
  TRACE;
  for(int i=_timeWindows->count()-1; i>=0; i--) {
    g.setX(i, refTime.secondsTo(_timeWindows->at(i).center()));
  }
  for(int i=_param->frequencySampling().count()-1; i>=0; i--) {
    g.setY(i, _param->frequencySampling().value(i));
  }
}

bool TaskManager::setParameters(Parameters * p)
{
  TRACE;
  ASSERT(_timeWindows);
  _param=p;
  int nRes=_stations->count()-1;
  int iRef=_param->referenceIndex();
  for(int iRes=0; iRes<nRes; iRes++) {
    int iStat=iRes<iRef ? iRes : iRes+1;
    _coherence[iRes].init(_timeWindows->count(), _param->frequencySampling().count());
    setGridCoordinates(_coherence[iRes], _stations->at(iStat)->startTime());
    _phase[iRes].init(_timeWindows->count(), _param->frequencySampling().count());
    setGridCoordinates(_phase[iRes], _stations->at(iStat)->startTime());
    _amplitude[iRes].init(_timeWindows->count(), _param->frequencySampling().count());
    setGridCoordinates(_amplitude[iRes], _stations->at(iStat)->startTime());
  }
  return true;
}

void TaskManager::setTimeWindows(TimeRangeList * r)
{
  TRACE;
  _timeWindows=r;
}

/*!
  Description of destructor still missing
*/
LoopWorker * TaskManager::newWorker()
{
  TRACE;
  Worker * w=new Worker;
  w->setTaskManager(this);
  return w;
}

void TaskManager::setTasks()
{
  TRACE;
  ParallelTaskManager::setTasks(_stations->count()-1);
}

ParallelTask * TaskManager::createTask(int taskIndex)
{
  ParallelTask * t=ParallelTaskManager::createTask(taskIndex);
  t->setStepCount(_timeWindows->count());
  // Avoid surprising results when stopping process in the middle
  _coherence[taskIndex].init(std::numeric_limits<double>::quiet_NaN());
  _phase[taskIndex].init(std::numeric_limits<double>::quiet_NaN());
  _amplitude[taskIndex].init(std::numeric_limits<double>::quiet_NaN());
  return t;
}

void TaskManager::addResult(int resIndex, int winIndex, int freqIndex,
                            double coherence, double phase, double amplitude) const
{
  TRACE;
  QMutexLocker ml(&_gridMutex);
  if(coherence>100.0) {
    coherence=100.0;
  }
  //printf("%10i %10i %10i %10lf %10lf\n", winIndex.stationIndex(), winIndex.windowIndex(), freqIndex, amplitude, phase);
  _coherence[resIndex].setValue(winIndex, freqIndex, coherence);
  _phase[resIndex].setValue(winIndex, freqIndex, phase);
  _amplitude[resIndex].setValue(winIndex, freqIndex, amplitude);
}
