/***************************************************************************
**
**  This file is part of phaseit.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-08-09
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMETERS_H
#define PARAMETERS_H

#include <GeopsyCore.h>

class Parameters : public AbstractParameters
{
public:
  Parameters();
  Parameters(const Parameters& o);

  virtual AbstractParameters * clone() const {return new Parameters(*this);}

  enum Domain {Time, Frequency};

  Domain domain() const {return _domain;}
  QString domainString() const;
  void setDomain(Domain d) {_domain=d;}
  void setDomain(const QString& d);

  TimeRangeParameters& timeRange() {return _timeRange;}
  const TimeRangeParameters& timeRange() const {return _timeRange;}
  void setTimeRange(const TimeRangeParameters& r) {_timeRange=r;}

  WindowingParameters& windowing() {return _windowing;}
  const WindowingParameters& windowing() const {return _windowing;}
  void setWindowing(const WindowingParameters& w) {_windowing=w;}

  SamplingParameters& frequencySampling() {return _frequencySampling;}
  const SamplingParameters& frequencySampling() const {return _frequencySampling;}

  double frequencyBandwidth() const {return _frequencyBandwidth;}
  void setFrequencyBandwidth(double f) {_frequencyBandwidth=f;}

  double maximumDelay() const {return _maximumDelay;}
  void setMaximumDelay(double d) {_maximumDelay=d;}

  int referenceIndex() const {return _referenceIndex;}
  void setReferenceIndex(int ref) {_referenceIndex=ref;}

  bool isValid(int stationCount) const;

  void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
  bool setValue(PARAMETERS_SETVALUE_ARGS);
  QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
  int totalKeywordCount(PARAMETERS_TOTALKEYWORDCOUNT_ARGS) const;
private:
  Domain _domain;
  TimeRangeParameters _timeRange;
  WindowingParameters _windowing;
  SamplingParameters _frequencySampling;
  double _frequencyBandwidth;
  double _maximumDelay;
  int _referenceIndex;
};

#endif // PARAMETERS_H
