/***************************************************************************
**
**  This file is part of matfiles.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-11-21
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GP_MATLAB_LIBS

#include "MatArray.h"

/*!
  \class MatArray MatArray.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MatArray::MatArray()
{
  TRACE;
  _type=Undefined;
  _realDouble=0;
  _imaginaryDouble=0;
  _complex=false;
}

/*!
  Description of destructor still missing
*/
MatArray::~MatArray()
{
  TRACE;
  delete [] _realDouble;
  delete [] _imaginaryDouble;
}

void MatArray::setFlags(quint32 f)
{
  TRACE;
  if(f & 0x00000800) {
    _complex=true;
  }
  // Ignore logical and global flags
  switch(f & 0x000000FF) {
  case 1:
    _type=CellArray;
    break;
  case 2:
    _type=Structure;
    break;
  case 3:
    _type=Object;
    break;
  case 4:
    _type=CharArray;
    break;
  case 5:
    _type=SparseArray;
    break;
  case 6:
    _type=DoubleArray;
    break;
  case 7:
    _type=FloatArray;
    break;
  case 8:
    _type=Int8Array;
    break;
  case 9:
    _type=UInt8Array;
    break;
  case 10:
    _type=Int16Array;
    break;
  case 11:
    _type=UInt16Array;
    break;
  case 12:
    _type=Int32Array;
    break;
  case 13:
    _type=UInt32Array;
    break;
  case 14:
    _type=Int64Array;
    break;
  case 15:
    _type=UInt64Array;
    break;
  default:
    _type=Undefined;
    break;
  }
}

void MatArray::addDimension(qint32 d)
{
  TRACE;
  _dimensions.append(d);
}

void MatArray::addNameChar(quint8 c)
{
  TRACE;
  _name.append(QChar(c));
}

qint64 MatArray::dataCount() const
{
  TRACE;
  qint64 n=1;
  for(QVector<qint32>::const_iterator it=_dimensions.begin(); it!=_dimensions.end(); it++) {
    n*=*it;
  }
  return n;
}

void MatArray::allocateData()
{
  TRACE;
  ASSERT(!_realDouble);
  ASSERT(!_imaginaryDouble);
  qint64 n=dataCount();
  // TODO: switch according to type
  _realDouble=new double[n];
  if(_complex) {
    _imaginaryDouble=new double[n];
  }
}

#endif // GP_MATLAB_LIBS
