/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**    Marc Wathelet (ISTerre, Grenoble, France)
**    Miriam Kristekova (Geophysical Institute, Academy of Sciences, Bratislava, Slovak Republic)
**
***************************************************************************/

#ifndef TOOLHVTFA_H
#define TOOLHVTFA_H

#include <GeopsyCore.h>
#include <GeopsyGui.h>

#include "HVTFAParameters.h"
#include "HVTFAIterator.h"

class ToolHVTFAd;
class HVTFALoop;
class HVTFAStationSignals;

class ToolHVTFA : public AbstractToolWidget
{
  Q_OBJECT
public:
  ToolHVTFA(QWidget* parent=0);
  ~ToolHVTFA();

public slots:
  virtual void start();
  void stop();
private slots:
  void startLoop();
protected:
  virtual bool initStations(SubSignalPool * subPool);
  virtual void updateAllFields();
  virtual AbstractParameters * parameters(AbstractParameters * param=0) const;
  virtual void setParameters(const AbstractParameters * param);
private:
  void setRangeList();

  StationList _stationSignals;
  QList <HVTFAStationSignals *> _stations;
  ToolHVTFAd * _d;
  HVTFAParameters _param;

  QString _log;
  HVTFALoop * _loop;
  HVTFAIterator * _iterator;
  bool _terminated;
};

#endif // TOOLHVTFA_H
