/***************************************************************************
**
**  This file is part of gpvoronoi.
**
**  gpvoronoi is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpvoronoi is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-14
**  Copyright: 2021

**
***************************************************************************/

#include <QGpCoreMath.h>

#include "gpvoronoiVersion.h"
#include "gpvoronoiInstallPath.h"
#include "Reader.h"

PACKAGE_INFO("gpvoronoi", GPVORONOI)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);
  a.debugUserInterrupts(false);

  // Options
  Reader reader;
  if(reader.setOptions(argc, argv)) {
    if(reader.read(argc, argv)) {
      return 0;
    } else {
      return 2;
    }
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  TRACE;
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS]");
  h->setComments("");
  h->addGroup("gpvoronoi", "gpvoronoi");
  h->addOption("-x-column <INDEX>", "Defines the X column index (default=0).");
  h->addOption("-y-column <INDEX>", "Defines the Y column index (default=1).");
  h->addOption("-delaunay", "Output only the Delaunay triangulation.");
  h->addOption("-limits <X1> <Y1> <X2> <Y2>", "Defines rectangular limits (default=10% larger than points).");
  return h;
}
